function In = NormalizarEspColor(I, space_color)


switch upper(space_color)
    case 'LAB'
        In(:,:,1) = I(:,:,1)/100;
        In(:,:,2) = (I(:,:,2) + 128)/(128*2);
        In(:,:,3) = (I(:,:,3) + 128)/(128*2);
    case 'LUV'
        In(:,:,1) = I(:,:,1)/100;
        In(:,:,2) = (I(:,:,2) + 200)/(200*2);
        In(:,:,3) = (I(:,:,3) + 200)/(200*2);
    case 'RGB'
        In(:,:,1) = I(:,:,1)/255;
        In(:,:,2) = I(:,:,2)/255;
        In(:,:,3) = I(:,:,3)/255;
    case 'YCBCR'
        In(:,:,1) = (I(:,:,1)-16)/(235-16);
        In(:,:,2) = (I(:,:,2)-16)/(246-16);
        In(:,:,3) = (I(:,:,3)-16)/(246-16);
    case {'HSL','HSV'}
        In(:,:,1) = I(:,:,1)/360;
        In(:,:,2) = I(:,:,2);
        In(:,:,3) = I(:,:,3);     
end

